<?php
//This script will check for missing dates in the DTHistory folder.  Sometimes the DT server didn't respond to the API call, so we need to check for missing dates and re-fetch them.

$begin = new DateTime('2012-09-08'); 
$end = new DateTime('2022-01-05');

$interval = DateInterval::createFromDateString('1 day');
$period = new DatePeriod($begin, $interval, $end);
$cnt = 0; //accumulator for order counts in each xml file
$missing = 0;

echo "Missing Dates:<br>";
foreach ($period as $dt) {
    if( !file_exists("DTHistory/".$dt->format("Y-m-d").".xml") ){
        echo $dt->format("Y-m-d")."<br>";
        $missing++;
    }
    $cnt++;
}
echo $missing." dates don't have XML files<br>";
echo $cnt." dates checked.";

?>
