-- Create syntax for 'orders'

CREATE TABLE `orders` (
  `pk` int(11) NOT NULL AUTO_INCREMENT,
  `order_number` varchar(12) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '',
  `id` varchar(12) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `customer_id` bigint(20) DEFAULT NULL,
  `first_name` varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `last_name` varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `email` varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `phone1` bigint(20) DEFAULT NULL,
  `phone2` bigint(20) DEFAULT NULL,
  `phone3` bigint(20) DEFAULT NULL,
  `address1` varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `address2` varchar(150) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `city` varchar(17) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `state` varchar(2) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `zip` int(11) DEFAULT NULL,
  `latitude` decimal(7,5) DEFAULT NULL,
  `longitude` decimal(7,5) DEFAULT NULL,
  `text_opt_out` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `email_opt_out` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `display_order_number` varchar(17) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `status` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `service_type` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `description` varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `account` int(11) DEFAULT NULL,
  `survey_status` varchar(13) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `stop_number` int(11) DEFAULT NULL,
  `route_locked` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `scheduled_at` varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `time_window_start` varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `time_window_end` varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `route_tag` int(11) DEFAULT NULL,
  `gps_arrive` varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `gps_depart` varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `service_time` int(11) DEFAULT NULL,
  `request_date` datetime DEFAULT NULL,
  `request_window_start_time` int(11) DEFAULT NULL,
  `request_window_end_time` int(11) DEFAULT NULL,
  `service_unit` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `service_unit_login` varchar(4) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `started_at` varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `finished_at` varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `amount` decimal(7,2) DEFAULT NULL,
  `cod_amount` decimal(2,1) DEFAULT NULL,
  `cod` decimal(6,2) DEFAULT NULL,
  `truck_id` varchar(4) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `truck_name` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `payment_notes` int(11) DEFAULT NULL,
  `payment_collected` int(11) DEFAULT NULL,
  `pieces` int(11) DEFAULT NULL,
  `volume` decimal(5,2) DEFAULT NULL,
  `delivery_charges` decimal(5,2) DEFAULT NULL,
  `sales_tax` decimal(5,2) DEFAULT NULL,
  `notes_count` int(11) DEFAULT NULL,
  `items_delivered_quantity` int(11) DEFAULT NULL,
  `items_count` int(11) DEFAULT NULL,
  `items_total_quantity` int(11) DEFAULT NULL,
  `images_count` int(11) DEFAULT NULL,
  `timeframe` varchar(17) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `shipment_id` int(11) DEFAULT NULL,
  `route_label` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `store_code` int(11) DEFAULT NULL,
  `sales_person` varchar(4) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `subtotal` decimal(7,2) DEFAULT NULL,
  `driver_compliance` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `custom_fields_level_of_satisfaction` int(11) DEFAULT NULL,
  `custom_fields_contact_free` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `signature_callback_code` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `signature_created_at` varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `surveys_count` int(11) DEFAULT NULL,
  `surveys_question` varchar(103) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `surveys_question_rating` int(11) DEFAULT NULL,
  `surveys_question_number` int(11) DEFAULT NULL,
  `surveys_question_comment` varchar(3) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `surveys_comments_count` int(11) DEFAULT NULL,
  `surveys_comments_comment` int(11) DEFAULT NULL,
  PRIMARY KEY (`pk`)
) ENGINE=InnoDB AUTO_INCREMENT=509747 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
