<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>DispatchTrak History Lookup</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <script src="external/jquery/jquery.js"></script>
  </head>
  <body>
    <div class="row">
      <div class="col-md-3">
        <div class="card">
          <form id="myForm" name="myForm">
            <div class="card-body" id="input-panel">
            <h3 class="card-title">Customer or Order Info</h3>
            <div class="input-group mb-3">
              <input id="order" name="order" type="text" class="form-control" placeholder="Order Number">
            </div>
            <div class="input-group mb-3">
              <input id="name" name="name" type="text" class="form-control" placeholder="Customer Last Name">
            </div>
            <div class="input-group mb-3">
              <input id="phone" name="phone" type="text" class="form-control" placeholder="Customer Phone">
            </div>

              <div class="input-group">
                <span class="input-group-btn">
                  <button id="searchbtn" class="btn btn-primary" type="button">Search!</button>
                </span>
              </div>
            </div>
          </form>
        </div>
      </div>
      <div class="col-md-8">
        <div class="card">
          <div class="card-body">
          <h3 class="card-title">List of associated order numbers: (click an order for details)</h3>
            <div id="mytable"></div>
          </div>
        </div>
      </div>
    </div>

  <script>
  //handle the search button click
  $('#searchbtn').on('click', function() {
    //test for input first
    var order =  $.trim( $('#order')[0].value );
    var name =  $.trim( $('#name')[0].value );
    var phone =  $.trim( $('#phone')[0].value );
    if (order == "" && name == "" && phone == "" ) {
      alert("You need a search parameter.");
    } else {
      if (order != ""){
        var posting = $.get("getorders.php", { order: order });
      }else if (name != "") {
        var posting = $.get("getorders.php", { name: name });
      } else {
        var posting = $.get("getorders.php", { phone: phone });
      }
      posting.done(function( data ) {
        var content = $( data );
        $( "#mytable" ).empty().append( content );
      });
    }
  });
  </script>
  <script>
  $('#mytable').on("click", '#ordertbl tr', function(){
    var $row = $(this).closest("tr"),
    $td1 = $row.find("td:nth-child(1)");
    //alert ($td1.text());
    if($td1.text() !== ''){ // if orderid
      var posting = $.get("orderInfo.php", { OrderID: $td1.text() });
      posting.done(function( data ) {
        var content = $( data );
        $( "#mytable" ).empty().append( content );
      });
    }
  });
  </script>
  
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p" crossorigin="anonymous"></script>

  </body>
</html>
